/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.command;

import android.text.TextUtils;
import com.gprinter.zb.ZPLUtilities;
import com.gprinter.zb.ZebraImageI;
import com.gprinter.zb.ZebraImageInternal;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class ZPLCommand {
    private static final String TAG = ZPLCommand.class.getSimpleName();
    Vector<Byte> Command = new Vector();

    public void addText(String font, Rotation rotation, int fontWidth, int fontHeight) {
        if (fontWidth < 10) {
            fontWidth = 10;
        } else if (fontWidth > 1500) {
            fontWidth = 1500;
        }
        if (fontHeight < 10) {
            fontHeight = 10;
        } else if (fontHeight > 1500) {
            fontHeight = 1500;
        }
        String str = font + "," + rotation.getValue() + "," + fontHeight + "," + fontWidth + "\r\n";
        this.addStrToCommand(str);
    }

    public void addAztecCode(Rotation a, Scale b, CodeMark c, int d, CodeMark e, int f, int g) {
        String barCode = "^B0" + a.getValue() + "," + b.getValue() + "," + c.getValue() + "," + d + "," + (Object)((Object)e) + "," + f + "," + g;
        this.addStrToCommand(barCode);
    }

    public void addCode11(Rotation o, CodeMark e, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B1" + o.getValue() + "," + e.getValue() + "," + h + "," + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCrossCode(Rotation o, int h, CodeMark f, CodeMark g, CodeMark e) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B2" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue() + "," + e.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCode39(Rotation o, CodeMark e, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B3" + o.getValue() + "," + e.getValue() + "," + h + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCode49(Rotation o, int h, Identifier f, Mode m) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B4" + o.getValue() + "," + h + "," + f.getValue() + "," + m.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCodePlanet(Rotation o, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B5" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addPDF417(Rotation o, int h, EC s, int c, int r, CodeMark t) {
        if (c > 30) {
            c = 30;
        } else if (c < 1) {
            c = 1;
        }
        if (r > 30) {
            r = 30;
        } else if (r < 1) {
            r = 1;
        }
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B7" + o.getValue() + "," + h + "," + s.getValue() + "," + c + "," + r + "," + t.getValue();
        this.addStrToCommand(barCode);
    }

    public void addEAN8(Rotation o, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B8" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addUPCE(Rotation o, int h, CodeMark f, CodeMark g, CodeMark e) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^B9" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue() + "," + e.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCode93(Rotation o, int h, CodeMark f, CodeMark g, CodeMark e) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BA" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue() + "," + e.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCode128(Rotation o, int h, CodeMark f, CodeMark g, CodeMark e, Code128Mode m) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BC" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue() + "," + e.getValue() + "," + m.getValue();
        this.addStrToCommand(barCode);
    }

    public void addEAN113(Rotation o, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BE" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addMicroPDF417(Rotation o, int h, int m) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        if (m > 33) {
            m = 33;
        } else if (m < 0) {
            m = 0;
        }
        String barCode = "^BF" + o.getValue() + "," + h + "," + m;
        this.addStrToCommand(barCode);
    }

    public void addCodeI25(Rotation o, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BI" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCodeJ25(Rotation o, int h, CodeMark f, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BJ" + o.getValue() + "," + h + "," + f.getValue() + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addCodabar(Rotation o, CodeMark e, int h, CodeMark f, CodeMark g, StartCharacter k, StartCharacter I) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BK" + o.getValue() + "," + e.getValue() + "," + h + "," + f.getValue() + "," + g.getValue() + "," + k.getValue() + "," + I.getValue();
        this.addStrToCommand(barCode);
    }

    public void addLogMars(Rotation o, int h, CodeMark g) {
        if (h > 9999) {
            h = 9999;
        } else if (h < 1) {
            h = 1;
        }
        String barCode = "^BL" + o.getValue() + "," + h + "," + g.getValue();
        this.addStrToCommand(barCode);
    }

    public void addStart() {
        String str = "^XA\r\n";
        this.addStrToCommand(str);
    }

    public void addEnd() {
        String str = "^XZ\r\n";
        this.addStrToCommand(str);
    }

    private String getBodyHeader(int var1, int var2, boolean var3, int var4, int var5) {
        StringBuffer var6 = new StringBuffer();
        var6.append("^FO");
        var6.append(var1);
        var6.append(",");
        var6.append(var2);
        var6.append("^GFA");
        var6.append(",");
        var6.append(var5);
        var6.append(",");
        var6.append(var5);
        var6.append(",");
        var6.append(var4);
        var6.append(",");
        String var7 = var6.toString();
        if (!var3) {
            var7 = "^XA" + var7;
        }
        return var7;
    }

    protected ZebraImageInternal scaleImage(int var1, int var2, ZebraImageInternal var3) {
        var3.scaleImage(var1, var2);
        return var3;
    }

    public void printImage(ZebraImageI var1, int var2, int var3, int var4, int var5, boolean var6) {
        ZebraImageInternal var7 = this.scaleImage(var4, var5, (ZebraImageInternal)var1);
        int var8 = (var7.getWidth() + 7) / 8;
        int var9 = var8 * var7.getHeight();
        String var10 = this.getBodyHeader(var2, var3, var6, var8, var9);
        String var11 = ZPLUtilities.replaceAllWithInternalCharacters(var10);
        this.addStrToCommand(var11);
        this.getDitheredImage(var7);
        if (!var6) {
            String var14 = ZPLUtilities.decorateWithFormatPrefix("^XZ");
            this.addStrToCommand(var14);
        }
    }

    public void getDitheredImage(ZebraImageInternal Image) {
        int w = Image.getWidth();
        int h = Image.getHeight();
        this.getDitheredImage(w, h, Image);
    }

    protected void getDitheredImage(int width, int height, ZebraImageInternal var2) {
        int i;
        int[] w = var2.getRow(0);
        int[] h = var2.getRow(1);
        int ww = width / 8 + (width % 8 == 0 ? 0 : 1);
        int pix = 8 - width % 8;
        if (pix == 8) {
            pix = 0;
        }
        byte[] var8 = new byte[ww];
        int var9 = 0;
        for (i = 0; i < width; ++i) {
            w[i] = ZPLCommand.convertByteToGrayscale(w[i]);
        }
        for (i = 0; i < height; ++i) {
            int var11;
            for (var11 = 0; var11 < var8.length; ++var11) {
                var8[var11] = 0;
            }
            var11 = 0;
            for (int var12 = 0; var12 < width; ++var12) {
                if (var12 % 8 == 0) {
                    var9 = -128;
                }
                int var13 = w[var12];
                var11 = var12 / 8;
                int var14 = var13 >= 128 ? -1 : 0;
                var8[var11] = (byte)(var8[var11] | var9 & var14);
                int var15 = var13 - (var14 & 0xFF);
                if (var12 < width - 1) {
                    int n = var12 + 1;
                    w[n] = w[n] + 7 * var15 / 16;
                }
                if (var12 > 0 && i < height - 1) {
                    int n = var12 - 1;
                    h[n] = h[n] + 3 * var15 / 16;
                }
                if (i < height - 1) {
                    if (var12 == 0) {
                        h[var12] = ZPLCommand.convertByteToGrayscale(h[var12]);
                    }
                    int n = var12;
                    h[n] = h[n] + 5 * var15 / 16;
                }
                if (i < height - 1 && var12 < width - 1) {
                    h[var12 + 1] = ZPLCommand.convertByteToGrayscale(h[var12 + 1]);
                    int n = var12 + 1;
                    h[n] = h[n] + 1 * var15 / 16;
                }
                var9 = (byte)((var9 & 0xFF) >>> 1);
            }
            var8[var11] = (byte)(var8[var11] | 255 >>> 8 - pix);
            this.addUserCommand(var8);
            w = h;
            h = var2.getRow(i + 2);
        }
    }

    private static int convertByteToGrayscale(int var0) {
        int r = (var0 & 0xFF0000) >>> 16;
        int g = (var0 & 0xFF00) >>> 8;
        int b = var0 & 0xFF;
        int gray = (r * 30 + g * 59 + b * 11) / 100;
        if (gray > 255) {
            gray = 255;
        } else if (gray < 0) {
            gray = 0;
        }
        return gray;
    }

    private void addStrToCommand(String str) {
        byte[] bs = null;
        if (!str.equals("")) {
            try {
                bs = str.getBytes("GB18030");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < bs.length; ++i) {
                this.Command.add(bs[i]);
            }
        }
    }

    public void addUserCommand(byte[] bytes) {
        if (bytes != null) {
            for (int i = 0; i < bytes.length; ++i) {
                this.Command.add(bytes[i]);
            }
        }
    }

    public void addUserCommand(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            byte[] bytes = new byte[]{};
            try {
                bytes = string.getBytes("GB18030");
                for (int i = 0; i < bytes.length; ++i) {
                    this.Command.add(bytes[i]);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public Vector<Byte> getCommand() {
        return this.Command;
    }

    public void addUserCommand(String string, String charsetName) throws UnsupportedEncodingException {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            byte[] bytes = string.getBytes(charsetName);
            for (int i = 0; i < bytes.length; ++i) {
                this.Command.add(bytes[i]);
            }
        }
    }

    public static enum EC {
        EC_1(1),
        EC(2),
        EC_3(3),
        EC_4(4),
        EC_5(5),
        EC_6(6),
        EC_7(7),
        EC_8(8);

        private final int value;

        private EC(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Scale {
        SCALE_1(1),
        SCALE_2(2),
        SCALE_3(3),
        SCALE_4(4),
        SCALE_5(5),
        SCALE_6(6),
        SCALE_7(7),
        SCALE_8(8),
        SCALE_9(9),
        SCALE_10(10);

        private final int value;

        private Scale(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum StartCharacter {
        A("A"),
        B("B"),
        C("C"),
        D("D"),
        E("E"),
        N("N"),
        T("C"),
        STAR("*");

        private final String value;

        private StartCharacter(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Code128Mode {
        N("N"),
        U("U"),
        A("A"),
        D("D");

        private final String value;

        private Code128Mode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Mode {
        Mode_A("A"),
        Mode_0("0"),
        Mode_1("1"),
        Mode_2("2"),
        Mode_3("3"),
        Mode_4("4"),
        Mode_5("5");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Identifier {
        N("N"),
        A("A"),
        B("B");

        private final String value;

        private Identifier(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum CodeMark {
        Mark_N("N"),
        Mark_Y("Y");

        private final String value;

        private CodeMark(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Rotation {
        ROTATION_0("N"),
        ROTATION_90("R"),
        ROTATION_180("I"),
        ROTATION_270("B");

        private final String value;

        private Rotation(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Font {
        FONT_A("^AA"),
        FONT_B("^AB"),
        FONT_C("^AC"),
        FONT_D("^AD"),
        FONT_E("^AE"),
        FONT_F("^AF"),
        FONT_G("^AG"),
        FONT_H("^AH"),
        FONT_BI("^AI"),
        FONT_J("^AJ"),
        FONT_K("^AK"),
        FONT_L("^AL"),
        FONT_M("^AM"),
        FONT_N("^AN"),
        FONT_O("^AO"),
        FONT_P("^AP"),
        FONT_Q("^AQ"),
        FONT_R("^AR"),
        FONT_S("^AS"),
        FONT_T("^AT"),
        FONT_U("^AU"),
        FONT_V("^AV"),
        FONT_W("^AW"),
        FONT_X("^AX"),
        FONT_Y("^AY"),
        FONT_Z("^AZ"),
        FONT_0("^A0"),
        FONT_1("^A1"),
        FONT_2("^A2"),
        FONT_3("^A3"),
        FONT_4("^A4"),
        FONT_5("^A5"),
        FONT_6("^A6"),
        FONT_7("^A7"),
        FONT_8("^A8"),
        FONT_9("^A9");

        private final String value;

        private Font(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

